unit IWGridCommon;

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel,
  {$ENDIF}
  Classes,
  {$IFDEF Linux}QGraphics,{$ELSE}Graphics,{$ENDIF}
  IWColor;

type

  TIWDBGridRefreshMode = (rmAutomatic, rmAlways, rmManual);

  TIWDBGridOption = (
    {$IFDEF VSNET}dgNone = 0,{$ENDIF}
    dgIndicator, dgShowTitles);

  TIWDBGridOptions = set of TIWDBGridOption;

  TIWGridLines = (tlAll, tlNone, tlRows, tlCols);

  TIWGridBorderStyle = (tfDefault, tfVoid, tfAbove, tfBelow, tvHorizSides, tfVertSides, tfLeft
    , tfRight);

  TIWGridVAlign = (vaMiddle, vaTop, vaBottom, vaBaseline);

  TIWOnCellClick = procedure(ASender: TObject; const ARow: Integer; const AColumn: Integer) of object;

  {$IFDEF VSNET}
  [TypeConverter(typeof(ExpandableObjectConverter))]
  {$ENDIF}
  TIWGridBorderColors = class(TPersistent)
  private
    FColor: TIWColor;
    FLight: TIWColor;
    FDark: TIWColor;
  public
    constructor Create; overload;
    constructor Create(AColor, ALight, ADark: TIWColor); overload;
  published
    property Color: TIWColor read FColor write FColor;
    property Light: TIWColor read FLight write FLight;
    property Dark: TIWColor read FDark write FDark;
  end;

var
  IWGridAlignments: array[TAlignment] of string = ('left', 'right', 'center');

implementation

{ TIWGridBorderColors }

constructor TIWGridBorderColors.Create;
begin
  inherited Create;
  Color := fromTColor(clNone);
  Light := fromTColor(clNone);
  Dark := fromTColor(clNone);
end;

constructor TIWGridBorderColors.Create(AColor, ALight, ADark: TIWColor);
begin
  inherited Create;
  FColor := AColor;
  FLight := ALight;
  FDark := ADark;
end;

end.
